#ifndef SIMULATIONENGINECONTROLLER_H_
#define SIMULATIONENGINECONTROLLER_H_

#include "SimulationEngineCommunication.h"
#include "EntityManager.h"
#include "EntityCommandManager.h"
#include "ControlCommandManager.h"
#include "../PhysicsEngine/IPhysicsController.h"
#include "SimulationEngineEncoderDecoder.h"
#include "../PhysicsEngine/PhysicsControllerFactory.h"
#include <iostream>
#include "../DataTypes/DataSimState.h"

#include "../DrawStuff/drawstuff.h"
using namespace DataTypes;
using namespace std;
using namespace PhysicsEngine;


namespace SimulationEngine
{

class SimulationEngineController
{
	
protected:
	SimulationEngineController();
public:
	static SimulationEngineController *GetInstance();
	void RunEngine(bool gui);
	void InitSimulation();
	void ResetSimulation();
	bool GetSyncMode();
	bool GetAutoAdjustMode();
	void SetAutoAdjustMode(bool autoadj);
	void SetStepsPerIteration(int stepsperiteration);
	void SetTimeStep(float timestep);
	void SetStepMode(bool stepmode);
	void SetSyncMode(bool syncmode);
	void SetStepFlag(bool stepflag);
	void SetFastMode(bool fastmode);
	void SetSyncWait(double syncwait);
	void SetWorldHardness(float hardness);
	void SetWorldBounciness(float bounciness);
	void SetWorldGravity(float gravx, float gravy, float gravz);
	void SetState(DataSimState data);
	void Synchronize(int iteration);
	bool GetInitialized();
	void FreeResources();
	DataSimState GetDataSimState();
	string GetPersistString();

	
	//private
	void simLoop (int pause);
	void command (int cmd);
	void startSimulation();

	
private:
	static SimulationEngineController *instance;
	bool autoadjustmode;
	int currentaveragecountsteps;
	int averagecountsteps;
	float lastaverageelapsedstep;
	int lastaveragestepsperiteration;
	double timelastadjust;
	float steplimit;
	
	bool initialized;
	bool syncmode;
	bool flagsync;
	bool stepmode;
	bool stepflag;
	bool broadcastflag;
	bool fastmode;
	float stepsize;
	double simulationTime;
	double lastTime;
	double lastSync;
	double syncwait;
	int itercount;
	Vector3f worldgravity;
	float worldhardness;
	float worldbounciness;
	int stepsperiteration;
	void SimulationLoop();
	void RfromQ (float *R, DataQuaternion quat);
	SimulationEngineCommunication *communication;
	IPhysicsController *physics;
	EntityManager *entitymanager;
	ControlCommandManager *controlcommandmgr;
	EntityCommandManager *entitycommandmgr;
	SimulationEngineEncoderDecoder *encoderdecoder;
	PhysicsControllerFactory *physicsfactory;
	ConfigurationServer *conf;
	
	double totaltime;
	
};

}

#endif /*SIMULATIONENGINECONTROLLER_H_*/
